#ifndef _PULSE_OXIMETER
#define _PULSE_OXIMETER


#include "derivative.h" /* include peripheral declarations */
#include "PublicTypes.h"
#include "ADC.h"
#include "AverageFilter.h"
#include "SwTimer.h"
#include "Kinetis_FTM.h"
#include "OPAMP.h"
//#include "TPM2.h"
//#include "TpmPwm1.h"

//#define POX_DEBUG
//#define POX_EXTERNAL_OPAMPS

/** ADC sampling period in ms */
#define POX_SAMPLING_PERIOD				1	//in ms

#ifdef POX_DEBUG
	#define POX_UPDATE_GRAPH_PERIOD			6	//in ms
#else
	#define POX_UPDATE_GRAPH_PERIOD			4	//in ms
#endif

/** ADC channel for pressure sensor output */
#define	POX_ADC_CHANNEL_OUTPUT_SIGNAL		0	//ADC1 channel number

/** ADC channel for heart beat signal */
#define	POX_ADC_CHANNEL_BASELINE_SIGNAL		0


#define	POX_REAL_TIME_DATA_ARRAY_LENGTH		64		//bytes

#define POX_ARRAY_LENGTH			8
#define OLDEST_ELEMENT				POX_ARRAY_LENGTH-1
#define NEWEST_ELEMENT				0


/* Change in K50 Board */

/* Switch control pin */
#define POX_PIN                          11
#define POX_PORT                         C         //Just to know
#define POX_CLOCK_CONF                   SIM_SCGC5 |= SIM_SCGC5_PORTC_MASK
#define POX_PIN_PCR                      PORTC_PCR11
#define POX_PIN_DIR_REG                  GPIOC_PDDR
#define POX_PIN_OUT_REG                  GPIOC_PDOR
#define POX_PIN_COR_REG                  GPIOC_PCOR

#define POX_INIT_SWITCH_CONTROL_PIN()	 POX_CLOCK_CONF;\
                                         POX_PIN_PCR= PORT_PCR_MUX(1);\
                                         POX_PIN_DIR_REG |= (1<<POX_PIN)

#define POX_SET_SWITCH_CONTROL(control)	 Pox_Set_Switch_Control (control)

#define POX_FIR

#if (defined POX_FIR)
#include "Kinetis_FIR.h"
#endif

void Pox_Set_Switch_Control (UINT8 Control);

/** Task that must be called periodically in tha main loop */
void  Pox_PeriodicTask(void);

/** Starts a Pox measurement 
	\returns TRUE if success, FALSE if already running */
UINT8 Pox_StartMeasurement(void);

/** Stops a Pox measurement */
void  Pox_AbortMeasurement(void);

/** Starts a Pox measurement 
	\returns TRUE if success, FALSE if already running */
UINT8 Pox_DiagnosticModeStartMeasurement(void);

/** Stops a Pox measurement */
void  Pox_DiagnosticModeStopMeasurement(void);


/** Call this function once before the main loop */
void Pox_Init(void);

/** Array of pointers to functions to execute Pox events */
extern const pFunc_t Pox_Events[];	

extern UINT8 Pox_HeartRate;
extern UINT8 Pox_SaturationValue;
extern UINT8 PoxGraph[];
extern UINT8 Pox_HeartBeatDetected;

/** These are the possible events that the Pox can generate */
typedef enum
{
	POX_EVENT_NONE,
	POX_EVENT_MEASUREMENT_COMPLETE_OK,
	POX_EVENT_MEASUREMENT_ERROR,
	POX_EVENT_NEW_DATA_READY,
	POX_EVENT_DEBUG_MODE_NEW_DATA_READY,
} Pox_Event_e;


/** Main Pox state machine states */
typedef enum
{
	POX_STATE_IDLE,
	POX_STATE_MEASURING	
} PoxStates_e;


#endif //_PULSE_OXIMETER